#include "analyzedemo.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>

analyzedemo::analyzedemo(configdata* in_config, demodata* in_demo, resultdata* in_result)
{
	all_kills_found = false;
	kill_count = 0;
	config = in_config;
	demo = in_demo;
	result = in_result;
	if (config->no_times == false) {
		printf ("\nGetting demos");
		get_demos ();
	}
	printf ("\nGetting players");
	get_players ();
	result->freeze();
	if ((config->gametype == gt_dm2) && (config->write_graph == true)) {
		printf ("\nAssigning origins");
		assign_origins ();
	}
	if (config->is_lmctf == true) {
		printf ("\nGetting LMCTF teams");
		get_teams_lmctf();
	}
	if (config->is_battle == true) {
		printf ("\nGetting Battle teams");
		get_teams_battle();
	}
	printf ("\nGetting kills");
	get_kills ();
	if (config->no_times == false) {
		printf ("\nGetting quad times");
		get_player_quad ();
		printf ("\nGetting most kills in one life");
		get_player_mkiol ();
		printf ("\nGetting demo playtime");
		get_total_time (); // must be before get_player_times!
		printf ("\nGetting player lifetimes");
		get_player_times ();
		printf ("\nGetting demo count");
		get_demo_count ();
	}
	printf ("\n\nAnalyzing done!\n");
}

analyzedemo::~analyzedemo()
{
}

void analyzedemo::get_players()
{
	if (config->gametype == gt_log) {
		printf ("\n\nPlease choose gametype (\"1\": Quake 2, \"2\": Quakeworld): ");
		char in_char = 0;
		in_char = _getch();
		printf ("\n\n");
		switch (in_char) {
		case '1':
			config->gametype = gt_dm2;
			get_players_log (config->get_first_Q2_msg(y_kills_x), y_kills_x);
			get_players_log (config->get_first_Q2_msg(selfkill), selfkill);
			break;
		case '2':
			config->gametype = gt_qwd;
			get_players_log (config->get_first_QW_msg(y_kills_x), y_kills_x);
			get_players_log (config->get_first_QW_msg(selfkill), selfkill);
			break;
		default:
			err->msg_and_exit ("You entered a wrong gametype!");
			break;
		}
	} else if ((config->gametype == gt_dm2) || (config->gametype == gt_qwd)) {
		int old_frame = 0;
		int new_frame = 0;
		bool exist[256];
		demodata_t* temp_data = demo->get_first_of_type (5);
		while (temp_data != 0) {
			if ((old_frame > new_frame) || (new_frame == 0)) {
				for (int i = 0; i < 256; i++) exist[i] = false;
			}
			old_frame = new_frame;
			int len = strlen (temp_data->message);
			if (len < 0) {
				err->msg_and_exit ("analyzedemo::get_players -> message size == %i !", len);
			}
			char* message = new char[len+1];
			strcpy (message, temp_data->message);
			int i = -1;
			if ((message[0] != 0) || (config->gametype == gt_qwd)) {
				if (config->gametype != gt_qwd) {
					while ((message[++i] != '\\') && (i < len));
					message[i] = 0;
				}
				if (exist[temp_data->vp_int[0]] == false) { // has player same id in whole game???
					result->add_player (message);
					exist[temp_data->vp_int[0]] = true;
				} else {
					// renamed! special treatment necessary!
					result->add_player (message);
				}
			}
			temp_data = temp_data->next_of_type;
			if (temp_data != 0) new_frame = temp_data->frame;
			delete[] message;
		}
	}
}

void analyzedemo::get_kills()
{
	if (config->gametype == gt_dm2) {
		test_for_msg (config->get_first_Q2_msg(y_kills_x), y_kills_x);
		test_for_msg (config->get_first_Q2_msg(x_kills_y), x_kills_y);
		test_for_msg (config->get_first_Q2_msg(selfkill), selfkill);
		test_for_msg (config->get_first_Q2_msg(death), death);
		test_for_msg (config->get_first_Q2_msg(extra_frags), extra_frags);
		test_for_msg (config->get_first_Q2_msg(flag_captures), flag_captures);
		test_for_msg (config->get_first_Q2_msg(ctf_assists), ctf_assists);
		test_for_msg (config->get_first_Q2_msg(ctf_helped_return), ctf_helped_return);
		test_for_msg (config->get_first_Q2_msg(flag_stolen), flag_stolen);
		test_for_msg (config->get_first_Q2_msg(flag_losses), flag_losses);
		test_for_msg (config->get_first_Q2_msg(flag_return), flag_return);
		test_for_msg (config->get_first_Q2_msg(ctf_defend_flag), ctf_defend_flag);
		test_for_msg (config->get_first_Q2_msg(ctf_defend_base), ctf_defend_base);
		test_for_msg (config->get_first_Q2_msg(ctf_defend_flagcarrier), ctf_defend_flagcarrier);
		test_for_msg (config->get_first_Q2_msg(ctf_defend_aggressive), ctf_defend_aggressive);
		test_for_msg (config->get_first_Q2_msg(flagcarrier_frag), flagcarrier_frag);
	} else if (config->gametype == gt_qwd) {
		test_for_msg (config->get_first_QW_msg(y_kills_x), y_kills_x);
		test_for_msg (config->get_first_QW_msg(x_kills_y), x_kills_y);
		test_for_msg (config->get_first_QW_msg(selfkill), selfkill);
		test_for_msg (config->get_first_QW_msg(death), death);
		test_for_msg (config->get_first_QW_msg(extra_frags), extra_frags);
		test_for_msg (config->get_first_QW_msg(flag_captures), flag_captures);
		test_for_msg (config->get_first_QW_msg(ctf_assists), ctf_assists);
		test_for_msg (config->get_first_QW_msg(ctf_helped_return), ctf_helped_return);
		test_for_msg (config->get_first_QW_msg(flag_stolen), flag_stolen);
		test_for_msg (config->get_first_QW_msg(flag_losses), flag_losses);
		test_for_msg (config->get_first_QW_msg(flag_return), flag_return);
		test_for_msg (config->get_first_QW_msg(ctf_defend_flag), ctf_defend_flag);
		test_for_msg (config->get_first_QW_msg(ctf_defend_base), ctf_defend_base);
		test_for_msg (config->get_first_QW_msg(ctf_defend_flagcarrier), ctf_defend_flagcarrier);
		test_for_msg (config->get_first_QW_msg(ctf_defend_aggressive), ctf_defend_aggressive);
		test_for_msg (config->get_first_QW_msg(flagcarrier_frag), flagcarrier_frag);
	}
	demo->build_next_of_type_list ();
}

void analyzedemo::test_for_msg (killtext_t* killmessage, int type)
{
	int weapon; 
	int player1int;
	int player2int;
	int len_front;
	int len_middle;
	int len_back;
	char front[256];
	char middle[256];
	char back[256];
	char* front_pos;
	char* middle_pos;
	char* back_pos;
	char player1[256];
	char player2[256];
	char* text;
	demodata_t* msgdata;
	demodata_t* last_msg;
	player_t* temp_player;
	if (all_kills_found == true) {
		return;
	}
	demodata_t* startmessage;
	startmessage = demo->get_first_of_type (1);
	while (killmessage != 0) {
		killmsg_front (front, killmessage);
		killmsg_middle (middle, killmessage);
		killmsg_back (back, killmessage);
		len_front = strlen (front);
		len_middle = strlen (middle);
		len_back = strlen (back);
		msgdata = demo->get_first_of_type (1);
		if (msgdata == 0) {
			msgdata = startmessage;
		}
		weapon = killmessage->weapon;
		all_kills_found = true;
		last_msg = msgdata;
		while (msgdata != 0) {
			if (config->is_lmctf == true) {
				if (((strstr (msgdata->message, "Red:") != 0) && (strstr (msgdata->message, "beats blue:") != 0))
					|| ((strstr (msgdata->message, "Blue:") != 0) && (strstr (msgdata->message, "beats red:") != 0))) {
					break;
				}
			}
			if (msgdata->used == true) {
				msgdata = msgdata->next_of_type;
				last_msg->next_of_type = msgdata;
				continue;
			}
			all_kills_found = false;
			text = msgdata->message;
			int textlen = strlen (text);
			front_pos = text;
			middle_pos = text;
			back_pos = text;
			if (len_front > 0) {
				front_pos = strstr (text, front);
			}
			if ((front_pos != 0) && (len_middle > 0)) {
				middle_pos = strstr (front_pos+strlen(front), middle);
			}
			if ((middle_pos != 0) && (len_back > 0)) {
				back_pos = strstr (middle_pos+strlen(middle), back);
			}
			if ((front_pos != 0) && (middle_pos != 0) && (back_pos != 0)) {
				if (back_pos == text) {
					back_pos = text + textlen;
				}
				strncpy (player1, text + len_front, middle_pos - front_pos - len_front);
				strncpy (player2, middle_pos + len_middle, back_pos - middle_pos - len_middle);
				player1[middle_pos - front_pos - len_front] = 0;
				player2[back_pos - middle_pos - len_middle] = 0;
				while (player2[strlen(player2)-1] == '\n') {
					player2[strlen(player2)-1] = 0;
				}
				player1int = 0;
				player2int = 0;
				for (int i = 1; i <= result->get_player_count(); i++) {
					temp_player = result->get_player (i);
					if (strnicmp (player1, temp_player->name, strlen (temp_player->name)) == 0) {
						player1int = i;
					}
					if (strnicmp (player2, temp_player->name, strlen (temp_player->name)) == 0) {
						player2int = i;
					}
				}
				if (player1int != 0) {
					count_kill (player1int, player2int, type, weapon, msgdata);
				}
			}
			last_msg = msgdata;
			msgdata = msgdata->next_of_type;
		}
		killmessage = killmessage->next;
	}
}

void analyzedemo::count_kill (int player1, int player2, int type, int weapon, demodata_t* message)
{
	if (player1 == 0) return;
	switch (type) {
	case y_kills_x:
		if (player2 == 0) return;
		result->add_kill (player2, player1, weapon);
		log_kill (player2, player1, weapon, message);
		break;
	case x_kills_y:
		if (player2 == 0) return;
		result->add_kill (player1, player2, weapon);
		log_kill (player1, player2, weapon, message);
		break;
	case selfkill:
		result->add_kill (player1, player1, weapon);
		log_kill (player1, player1, weapon, message);
		break;
	case death:
		result->add_death (player1, weapon);
		log_kill (-1, player1, weapon, message);
		break;
	case extra_frags: // weapon is number of frags to add
		result->add_extra_frags (player1, weapon);
		break;
	case flag_captures:
		result->add_flag_capture (player1, weapon);
		break;
	case ctf_assists:
		result->add_ctf_assist (player1, weapon);
		break;
	case ctf_helped_return:
		result->add_ctf_helped_return (player1, weapon);
		break;
	case flag_stolen:
		result->add_flag_steal (player1, weapon);
		break;
	case flag_losses:
		result->add_flag_loss (player1, weapon);
		break;
	case flag_return:
		result->add_flag_return (player1, weapon);
		break;
	case ctf_defend_flag:
		result->add_ctf_defend_flag (player1, weapon);
		break;
	case ctf_defend_base:
		result->add_ctf_defend_base (player1, weapon);
		break;
	case ctf_defend_flagcarrier:
		result->add_ctf_defend_flagcarrier (player1, weapon);
		break;
	case ctf_defend_aggressive:
		result->add_ctf_defend_aggressive (player1, weapon);
		break;
	case flagcarrier_frag:
		result->add_flagcarrier_frag (player1, weapon);
		break;
	}
	message->used = true;
}

char* analyzedemo::killmsg_front (char* front, killtext_t* killmessage) 
{
	int pos = -1;
	while ((killmessage->text[++pos] != '%') && (pos < strlen (killmessage->text)));
	if (pos > 0+1) {
		strncpy (front, killmessage->text, pos-1);
		front[pos-1] = 0;
	} else {
		front[0] = 0;
	}
	return front;
}

char* analyzedemo::killmsg_middle (char* middle, killtext_t* killmessage) 
{
	int pos1 = -1;
	while ((killmessage->text[++pos1] != '%') && (pos1 < strlen (killmessage->text)));
	int pos2 = pos1;
	while ((killmessage->text[++pos2] != '%') && (pos2 < strlen (killmessage->text)));
	if (pos2 > pos1) {
		strncpy (middle, killmessage->text+pos1+1, pos2-pos1);
		middle[pos2-pos1-1] = 0;
	} else {
		middle[0] = 0;
	}
	return middle;
}

char* analyzedemo::killmsg_back (char* back, killtext_t* killmessage) 
{
	int pos = -1;
	while ((killmessage->text[++pos] != '%') && (pos < strlen (killmessage->text)));
	while ((killmessage->text[++pos] != '%') && (pos < strlen (killmessage->text)));
	int len = strlen (killmessage->text);
	if (len > pos+1) {
		strncpy (back, killmessage->text+pos+1, len-pos-1);
		back[len-pos-1] = 0;
	} else {
		back[0] = 0;
	}
	return back;
}

void analyzedemo::log_kill (int killer, int victim, int weapon, demodata_t* message) 
{
	message->killer = killer;
	message->victim = victim;
	message->weapon = weapon;
	kill_count++;
}

void analyzedemo::get_player_mkiol() // possible errors for multiple demos!!!
{
	int lastframe = 0;
    for (int i = 1; i <= result->get_player_count(); i++) {
		int temp = 0;
		int mkiol = 0;
		demodata_t* message = demo->get_first_of_type(1);
		while (message != 0) {
			if ((message->killer == i) && (message->victim != i)) {
				temp++;
			}
			if ((message->victim == i) || (lastframe > message->frame)) {
				if (temp > mkiol) {
					mkiol = temp;
				}
				temp = 0;
			}
			lastframe = message->frame;
			message = message->next_of_type;
		}
		if (temp > mkiol) {
			mkiol = temp;
		}
		result->set_player_mkiol (i, mkiol);
	}
}

void analyzedemo::get_player_quad() // possible errors for multiple demos!!!
{
	int lastframe = 0;
    for (int i = 1; i <= result->get_player_count(); i++) {
		int pnum = -1;
		char* name = result->get_player(i)->name;
		int quadtime = 0;
		demodata_t* message = demo->get_first();
		demodata_t* last = message;
		demodata_t* temp = 0;
		while (message != 0) {
			if (temp != 0) {
				if (message->time - temp->time >= 300) {
					quadtime += 300;
					temp = 0;
				}
			}
			switch (message->type) {
			case 1:
				if (temp != 0) {
					if ((message->victim != i) && (message->killer == i)) {
						result->get_player(i)->quad_kills++;
					}
					if (message->victim == i) {
						if (message->time - temp->time < 300) {
							quadtime += message->time - temp->time;
						} else {
							quadtime += 300;
						}
						temp = 0;
					} else if (message->frame < temp->frame) {
						pnum = -1;
						if (last->time - temp->time < 300) {
							quadtime += last->time - temp->time;
						} else {
							quadtime += 300;
						}
						temp = 0;
					}
				}
				break;
			case 5:
				if (strnicmp (name, message->message, strlen(name)) == 0) {
					pnum = message->vp_int[0];
				}
				break;
			case 222:
				if (temp == 0) {
					if (message->vp_int[0] == pnum) {
						temp = message;
					}
				}
				break;
			}
			last = message;
			message = message->next;
		}
		result->get_player(i)->quad_time = quadtime;
	}
}

void analyzedemo::get_player_times()
{
	// don't delete nullplayers before this function was called!!!
	int i;
	int pnum;
	bool match_running;
	int* spawntime;
	spawntime = new int[1024];
	int* lifetime;
	lifetime = new int[1024];
	int* lifecount;
	lifecount = new int[1024];
	char** lastname;
	lastname = new char*[1024];
	for (i = 0; i < 1024; i++) {
		lifetime[i] = 0;
		lifecount[i] = 0;
		spawntime[i] = -1;
		lastname[i] = new char[65];
		lastname[i][0] = 0;
	}
	demodata_t* pos = demo->get_first();
	demodata_t* oldpos = pos;
	match_running = !(config->is_battle);
	while (pos != 0) {
		switch (pos->type) {
		case 1: // frag
			if (strstr (pos->message, "Match has begun. Good luck!") != 0) {
				match_running = true;
			}
			if (strstr (pos->message, "Match paused by") != 0) {
				for (i = 0; i < result->get_player_count(); i++) {
					if (spawntime[i] > -1) {
						int time = (pos->time - spawntime[i]);
						lifetime[i] += oldpos->time - spawntime[i];
						result->set_player_lifetime_longest(i+1, time);
						result->set_player_lifetime_shortest(i+1, time);
					}
				}
				match_running = false;
			}
			if (strstr (pos->message, "Game resumed by") != 0) {
				for (i = 0; i < result->get_player_count(); i++) {
					if (spawntime[i] > -1) {
						spawntime[i] = pos->time;
					}
				}
				match_running = true;
			}
			if (strstr (pos->message, "Timelimit hit.  Match ended.") != 0) {
				for (i = 0; i < result->get_player_count(); i++) {
					if (spawntime[i] > -1) {
						int time = (pos->time - spawntime[i]);
						lifetime[i] += oldpos->time - spawntime[i];
						result->set_player_lifetime_longest(i+1, time);
						result->set_player_lifetime_shortest(i+1, time);
					}
				}
				match_running = false;
			}
			if (pos->victim > -1) { // victims, suicides, deaths
				if (spawntime[pos->victim-1] > -1) {
					if (match_running == true) {
						int time = pos->time - spawntime[pos->victim-1];
						lifetime[pos->victim-1] += time;
						result->set_player_lifetime_longest(pos->victim, time);
						result->set_player_lifetime_shortest(pos->victim, time);
					}
					spawntime[pos->victim-1] = -1;
				}
			}
			break;
		case 5: // skin
			char tempstr[256];
			if (pos->message[0] != 0) { // spawn
				strcpy (tempstr, pos->message);
				i = -1;
				while (tempstr[++i] != '\\');
				tempstr[i] = 0;
				if ((stricmp (tempstr, lastname[pos->vp_int[0]-1]) != 0) &&
				(lastname[pos->vp_int[0]-1][0] != 0)) { // renamed
					pnum = result->get_player_number(lastname[pos->vp_int[0]-1]) - 1;
					if (spawntime[pnum] > -1) {
						if (match_running == true) {
							int time = (pos->time - spawntime[pnum]);
							lifetime[pnum] += time;
							result->set_player_lifetime_longest(pnum+1, time);
							result->set_player_lifetime_shortest(pnum+1, time);
						}
						spawntime[pnum] = -1;
					}
					strcpy (lastname[pos->vp_int[0]-1], tempstr);
					pnum = result->get_player_number(tempstr) - 1;
				} else { // not renamed
					pnum = result->get_player_number(tempstr) - 1;
					strcpy (lastname[pos->vp_int[0]-1], tempstr);
				}
				if (spawntime[pnum] == -1) { // real spawn
					if (match_running == true) {
						lifecount[pnum]++;
					}
					spawntime[pnum] = pos->time;
				}
			} else { // disconnect
				int pnum = result->get_player_number(lastname[pos->vp_int[0]-1]) - 1;
				if (spawntime[pnum] > -1) {
					if (match_running == true) {
						int time = (pos->time - spawntime[pnum]);
						lifetime[pnum] += time;
						result->set_player_lifetime_longest(pnum+1, time);
						result->set_player_lifetime_shortest(pnum+1, time);
					}
					spawntime[pnum] = -1;
				}
			}
			break;
		case 100: // new demo, reset
			for (i = 0; i < result->get_player_count(); i++) {
				if (spawntime[i] > -1) {
					if (match_running == true) {
						int time = (pos->time - spawntime[i]);
						lifetime[i] += oldpos->time - spawntime[i];
						result->set_player_lifetime_longest(i+1, time);
						result->set_player_lifetime_shortest(i+1, time);
					}
					spawntime[i] = -1;
					lastname[i][0] = 0;
				}
			}
			break;
		default:
			break;
		}
		oldpos = pos;
		pos = pos->next;
	}
	for (i = 0; i < result->get_player_count(); i++) {
		if (spawntime[i] > -1) {
			if (match_running == true) {
				int time = (oldpos->time - spawntime[i]);
				lifetime[i] += oldpos->time - spawntime[i];
				result->set_player_lifetime_longest(i+1, time);
				result->set_player_lifetime_shortest(i+1, time);
			}
		}
		result->set_player_lifetime_total (i+1, lifetime[i]);
		if (lifecount[i] != 0) {
			result->set_player_lifetime_average (i+1, lifetime[i]/lifecount[i]);
		} else {
			result->set_player_lifetime_average (i+1, 0);
		}
	}
	for (i = 0; i < 1024; i++) {
		delete[] lastname[i]; // necessary???
	}
	delete[] spawntime;
	delete[] lifetime;
	delete[] lifecount;
	delete[] lastname;
}

demodata_t* analyzedemo::find_next_playerspawn(demodata_t * pos, char* playername)
{
	while ((pos != 0) && (pos->type != 5)) {
		pos = pos->next;
	}
	if (pos == 0) return 0;
	while ((pos != 0) && ((strnicmp (pos->message, playername, strlen(playername)) != 0) || (pos->message[0] == 0))) {
		pos = pos->next_of_type;
	}
	return pos;
}

demodata_t* analyzedemo::find_next_death(demodata_t* pos, int player_id)
{
	while ((pos != 0) && (pos->type != 1)) {
		pos = pos->next;
	}
	if (pos == 0) return 0;
	while (pos->victim != player_id) {
		pos = pos->next_of_type;
		if (pos == 0) return 0;
	}
	return pos;
}

demodata_t* analyzedemo::find_end_of_demo(demodata_t * pos)
{
	pos = pos->next;
	demodata_t* oldpos = pos;
	while ((pos != 0) && (pos->type != 100)) {
		oldpos = pos;
		pos = pos->next;
	}
	return oldpos;
}

void analyzedemo::get_total_time()
{
	int total_time = 0;
	int start_time = 0;
	demodata_t* oldpos;
	demodata_t* pos = demo->get_first();
	if (config->is_battle == true) {
		pos = demo->get_first_of_type (1);
		while (pos != 0) {
			if (strstr (pos->message, "Match has begun. Good luck!") != 0) {
				start_time = pos->time;
			}
			if (strstr (pos->message, "Match paused by") != 0) {
				total_time += pos->time - start_time;
			}
			if (strstr (pos->message, "Game resumed by") != 0) {
				start_time = pos->time;
			}
			if (strstr (pos->message, "Timelimit hit.  Match ended.") != 0) {
				total_time += pos->time - start_time;
			}
			oldpos = pos;
			pos = pos->next_of_type;
		}
	} else {
		pos = demo->get_first();
		while (pos != 0) {
			oldpos = pos;
			total_time += pos->frame;
			pos = find_end_of_demo (pos);
		}
	}
	result->set_total_time (total_time);
}

void analyzedemo::get_demo_count()
{
	int demo_count = 0;
	demodata_t* temp = demo->get_first_of_type(100);
	while (temp != 0) {
		demo_count++;
		temp = temp->next_of_type;
	}
	result->set_demo_count (demo_count);
}

demodata_t* analyzedemo::find_next_disconnect(demodata_t* pos, int player_id)
{
	while ((pos != 0) && (pos->type != 5)) {
		pos = pos->next;
	}
	if (pos == 0) return 0;
	while ((pos != 0) && ((pos->vp_int[0] != player_id) || (pos->message[0] != 0))) {
		pos = pos->next_of_type;
	}
	return pos;
}

void analyzedemo::get_players_log(killtext_t* killmessage, int type)
{
	int weapon; 
	int len_front;
	int len_middle;
	int len_back;
	char front[256];
	char middle[256];
	char back[256];
	char* front_pos;
	char* middle_pos;
	char* back_pos;
	char player1[256];
	char player2[256];
	char* text;
	demodata_t* msgdata;
	demodata_t* last_msg;
	if (all_kills_found == true) {
		return;
	}
	while (killmessage != 0) {
		killmsg_front (front, killmessage);
		killmsg_middle (middle, killmessage);
		killmsg_back (back, killmessage);
		len_front = strlen (front);
		len_middle = strlen (middle);
		len_back = strlen (back);
		msgdata = demo->get_first_of_type (1);
		if (msgdata == 0) {
			msgdata = demo->get_first_of_type (2);
		}
		weapon = killmessage->weapon;
		all_kills_found = true;
		last_msg = msgdata;
		while (msgdata != 0) {
			all_kills_found = false;
			text = msgdata->message;
			int textlen = strlen (text);
			front_pos = text;
			middle_pos = text;
			back_pos = text;
			if (len_front > 0) {
				front_pos = strstr (text, front);
			}
			if ((front_pos != 0) && (len_middle > 0)) {
				middle_pos = strstr (front_pos+strlen(front), middle);
			}
			if ((middle_pos != 0) && (len_back > 0)) {
				back_pos = strstr (middle_pos+strlen(middle), back);
			}
			if ((front_pos != 0) && (middle_pos != 0) && (back_pos != 0)) {
				if (back_pos == text) {
					back_pos = text + textlen;
				}
				strncpy (player1, text + len_front, middle_pos - front_pos - len_front);
				strncpy (player2, middle_pos + len_middle, back_pos - middle_pos - len_middle);
				player1[middle_pos - front_pos - len_front] = 0;
				player2[back_pos - middle_pos - len_middle] = 0;
				while (player2[strlen(player2)-1] == '\n') {
					player2[strlen(player2)-1] = 0;
				}
				if (player1[0] != 0) {
					result->add_player (player1);
				}
				if (player2[0] != 0) {
					result->add_player (player2);
				}
			}
			last_msg = msgdata;
			msgdata = msgdata->next_of_type;
		}
		killmessage = killmessage->next;
	}
}

void analyzedemo::get_teams_lmctf()
{
	demodata_t* temp_data = demo->get_first_of_type (5);
	while (temp_data != 0) {
		int len = strlen (temp_data->message);
		char* message = new char[len+1];
		strcpy (message, temp_data->message);
		int i = -1;
		while ((message[++i] != '\\') && (i < len));
		message[i] = 0;
		int player = result->get_player_number (message);
		strcpy (message, temp_data->message);
		i = strlen (message);
		while ((message[--i] != '-') && (i > 0));
		switch (message[i+1]) {
		case 'b':
		case 'B':
			result->set_player_team (player, 0);
			break;
		case 'r':
		case 'R':
			result->set_player_team (player, 1);
			break;
		}
		delete[] message;
		temp_data = temp_data->next_of_type;
	}
}

void analyzedemo::get_teams_battle()
{
	if (config->is_battle == false) {
		return;
	}
	char team1[64] = "";
	char team2[64] = "";
	demodata_t* temp_data = demo->get_first_of_type (5);
	while (temp_data != 0) {
		int len = strlen (temp_data->message);
		char* message = new char[len+1];
		char* skin;
		strcpy (message, temp_data->message);
		int i = -1;
		while ((message[++i] != '\\') && (i < len));
		message[i] = 0;
		skin = message+i+1;
		int player = result->get_player_number (message);
		strcpy (message, temp_data->message);
		if (team1[0] == 0) {
			strcpy (team1, skin);
		} 
		if ((team2[0] == 0) && (strcmp (team1, skin) != 0)) {
			strcpy (team2, skin);
		}
		if (strcmp (skin, team1) == 0) {
			result->set_player_team (player, 0);
		} else if (strcmp (skin, team2) == 0) {
			result->set_player_team (player, 1);
		} else {
			result->set_player_team (player, 2);
		}
		delete[] message;
		temp_data = temp_data->next_of_type;
	}
}

void analyzedemo::get_demos()
{
	demodata_t* demopos = demo->get_first_of_type(100);
	demodata_t* oldpos = demopos;
	while (demopos != 0) {
		demodata_t* temppos = demopos;
		while ((temppos->next != 0) && (temppos->next->type != 100)) {
			temppos = temppos->next;
		}
		result->add_demo (demopos->message, atoi (demopos->next->message), temppos->frame/10);
		demodata_t* mapfilepos = demopos;
		demodata_t* mapnamepos = demopos;
		for (;;) {
			if (demopos->next_of_type != 0) {
				while ((mapfilepos->id < demopos->next_of_type->id) && (mapfilepos->type != 4)) {
					mapfilepos = mapfilepos->next;
				}
				while ((mapnamepos->id < demopos->next_of_type->id) && (mapnamepos->type != 6)) {
					mapnamepos = mapnamepos->next;
				}
				if ((mapfilepos->id >= demopos->next_of_type->id) || (mapnamepos->id >= demopos->next_of_type->id)) {
					break;
				}
			} else {
				while ((mapfilepos != 0) && (mapfilepos->type != 4)) {
					mapfilepos = mapfilepos->next;
				}
				while ((mapnamepos != 0) && (mapnamepos->type != 6)) {
					mapnamepos = mapnamepos->next;
				}
				if ((mapfilepos == 0) || (mapnamepos == 0)) {
					break;
				}
			}
			if ((mapfilepos->type == 4) && (mapnamepos->type == 6)) {
				if (result->last_map != 0) {
					result->last_map->seconds = (mapnamepos->time-oldpos->time)/10;
				}
				result->add_map (mapnamepos->message, mapfilepos->message); 
				oldpos = mapfilepos;
			}
			mapfilepos = mapfilepos->next;
			mapnamepos = mapnamepos->next;
			if ((mapfilepos == 0) || (mapnamepos == 0)) {
				break;
			}
		}
		demopos = demopos->next_of_type;
	}
	if (result->last_map != 0) {
		result->last_map->seconds = (demo->get_last()->time-oldpos->time)/10;
	}
}

void analyzedemo::assign_origins()
{
	int i;
	int* last_num;
	last_num = new int[1025];
	for (i = 0; i < 1025; i++) {
		last_num[i] = -1;
	}
	demodata_t* pos = demo->get_first();
	while (pos != 0) {
		switch (pos->type) {
		case 5: // skin
			char tempstr[256];
			if (pos->message[0] != 0) { // spawn
				strcpy (tempstr, pos->message);
				int i = -1;
				while (tempstr[++i] != '\\');
				tempstr[i] = 0;
				last_num[pos->vp_int[0]] = result->get_player_number(tempstr);
			} else { // disconnect
				// ???
			}
			break;
		case 111:
			if (last_num[pos->vp_int[0]] > -1) {
				pos->killer = last_num[pos->vp_int[0]];
				pos->victim = last_num[pos->vp_int[0]];
			} else {
				pos->killer = -1;
				pos->victim = -1;
			}
		default:
			break;
		}
		pos = pos->next;
	}
	delete[] last_num;
}
